<?php

namespace app\user\controller;

use app\common\controller\Frontend;
use app\common\library\Ems;
use app\common\library\Sms;
use app\home\model\GoodsOrder;
use hehe\Network;
use hehe\Trade;
use think\Config;
use think\Cookie;
use think\Db;
use think\Hook;
use think\Validate;

class Merchant extends Frontend {

    protected $layout = 'default';

    protected $noNeedRight = '*';
    protected $noNeedLogin = [];


    public function _initialize() {
        parent::_initialize(); // TODO: Change the autogenerated stub

        if (!Config::get('fastadmin.usercenter')) {
            $this->error(__('User center already closed'), '/');
        }

        if (!$this->request->isPjax()) {
            $this->view->engine->layout('default/layout/' . $this->layout);

        }

    }


    public function index() {

        if ($this->request->isPost()) {
            $params = $this->request->param();
            //            $this->success('已开通');
            if (empty($params['grade_id'])) $this->error('请选择分站类型');
            $grade = db::name('merchant_grade')->where(['id' => $params['grade_id']])->find();
            if ($this->user['money'] < $grade['money']) $this->error('余额不足，请充值');
            $insert = [];
            $insert['grade_id'] = $params['grade_id'];
            $insert['money'] = $grade['money'];

            if ($grade['domain']) {
                if (empty($params['top_domain'])) $this->error('请输入您的独立域名');
                $res = db::name('merchant')->where(['domain' => $params['top_domain']])->find();
                if ($res) $this->error('域名已使用');
                $insert['domain'] = $params['top_domain'];
            } else {
                if (empty($params['prefix'])) $this->error('请输入域名前缀');
                $res = db::name('merchant')->where(['prefix' => $params['prefix'], 'grade_id' => $params['grade_id']])->find();
                if ($res) $this->error('域名前缀已被使用');
                if (empty($params['domain_id'])) $this->error('请选择域名');
                $insert['prefix'] = $params['prefix'];
                $insert['translate_id'] = $params['domain_id'];
                $translate = db::name('merchant_domain')->where(['id' => $params['domain_id']])->find();
                $insert['translate'] = $translate['domain'];
                $insert['domain'] = $insert['prefix'] . '.' . $insert['translate'];
            }

            if($insert['domain'] == Network::getHostDomain()) $this->error('域名输入错误');

            $insert['user_id'] = $this->user['id'];
            $insert['create_time'] = time();
            db::name('user')->where(['id' => $this->user['id']])->setDec('money', $grade['money']);
            $res = db::name('merchant')->insert($insert);
            $this->success('已开通');

        }

        $list = db::name('merchant_grade')->order('weigh desc')->select();

        $domain_list = db::name('merchant_domain')->order('weigh desc')->select();

        $grade_json = [];

        foreach ($list as $val) {
            $grade_json['_' . $val['id']] = ['domain' => $val['domain']];
        }

        $merchantModel = new \app\user\model\Merchant;

        $merchant_list = $merchantModel->with(['grade'])->where(['user_id' => $this->user['id']])->order('id desc')->paginate(10);

        $this->assign([
            'list' => $list, //分站等级列表
            'domain_list' => $domain_list, //域名列表
            'grade_json' => json_encode($grade_json), //分站等级列表
            'merchant_list' => $merchant_list, //我的分站
        ]);
        return view('default/merchant/index');
    }



}
